/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.modern.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopScreen;
import net.sixik.sdmshoprework.client.screen.modern.buyer.ModernBuyerScreen;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.TextRenderHelper;

public class ModernShopEntryButton
extends AbstractShopEntryButton {
    private static final DecimalFormat PRICE_FORMAT = new DecimalFormat("#,##0.00");

    public ModernShopEntryButton(Panel panel, AbstractShopEntry entry) {
        super(panel, entry);
    }

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isSelected()) {
            RGBA.create((int)255, (int)255, (int)255, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        } else {
            RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        }
    }

    public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        this.drawBackground(graphics, theme, x, y, w, h);
        if (this.entry != null) {
            int iconSize = h - 12;
            this.drawIcon(graphics, theme, x + (w - iconSize) / 2, y + 2, iconSize, iconSize);
            MutableComponent component = this.entry.isSell ? Component.m_237115_((String)"sdm.shop.entry.sell") : Component.m_237115_((String)"sdm.shop.entry.buy");
            float buySellScale = 0.7f;
            int textWidth = (int)TextRenderHelper.getTextWidth((String)component.getString(), (float)buySellScale);
            int centeredX = x + (w - textWidth) / 2;
            PoseStack poseStack = graphics;
            poseStack.m_85836_();
            poseStack.m_85837_((double)centeredX, (double)(y + h - 8), 0.0);
            poseStack.m_85841_(buySellScale, buySellScale, 1.0f);
            theme.drawString(poseStack, (Object)component, 0, 0);
            poseStack.m_85849_();
            RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x + 2, y + h + 2, w - 4, 8, 2);
            double price = this.entry.entryPrice;
            Object textMoney = price < 1000.0 ? String.valueOf((int)price) : (price < 1000000.0 ? String.format("%.1f", price / 1000.0).replace(".0", "") + "k" : String.format("%.1f", price / 1000000.0).replace(".0", "") + "M");
            float priceScale = 0.7f;
            textWidth = (int)TextRenderHelper.getTextWidth((String)textMoney, (float)priceScale);
            centeredX = x + 2 + (w - 4 - textWidth) / 2;
            poseStack.m_85836_();
            poseStack.m_85837_((double)centeredX, (double)(y + h + 3), 0.0);
            poseStack.m_85841_(priceScale, priceScale, 1.0f);
            theme.drawString(poseStack, textMoney, 0.0f, 0.0f, theme.getContentColor(this.getWidgetType()), 2);
            poseStack.m_85849_();
        } else {
            int size = this.height / 2;
            this.drawIcon(graphics, theme, x + size / 2, y + size / 2, w - size, h - size);
        }
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        super.addMouseOverText(list);
        if (this.entry != null) {
            list.add((Component)Component.m_237119_());
            String priceString = "$" + PRICE_FORMAT.format(this.entry.entryPrice);
            list.add((Component)Component.m_237110_((String)"gui.sdm.shop.price.tooltip", (Object[])new Object[]{priceString}));
        }
    }

    @Override
    public void openBuyScreen() {
        new ModernBuyerScreen((ModernShopScreen)this.getShopScreen(), this).openGui();
    }
}

